<?php

class WC_Paygenius_Redirect extends WC_Payment_Gateway
{

    function __construct()
    {

        $this->id                 = 'paygenius-redirect';
        $this->icon               = WP_PLUGIN_URL."/".plugin_basename(dirname(dirname(__FILE__))).'/images/paygenius_logo_black.png';
        $this->has_fields         = false;
        $this->method_title       = 'PayGenius Redirect';
        $this->method_description = 'PayGenius payment gateway (hosted interface)';
        $this->order_button_text  = __('Proceed to PayGenius', 'woocommerce');

        $this->title              = $this->get_option( 'title' , 'PayGenius Secure payment processing via Credit Card or EFT for South Africa');
        //$this->title              = $this->get_option( 'title' , 'PayGenius');
        $this->description        = $this->get_option( 'description' , 'Pay by Credit Card, Debit Card, Instant EFT');
        //$this->order_button_text        = $this->get_option( 'button-text' , 'PayGenius with PayGenius');
        $this->order_button_text        = $this->get_option( 'button-text' , 'Place order');
        

        if ($this->is_test_mode()) {
            $this->title = "Test Mode Enabled";
        }

        $this->init_form_fields();
        $this->init_settings();

        if ($this->is_supported() && $this->is_activated()) {
            $this->enabled = $this->get_option('enabled');
        }

        add_action('woocommerce_update_options_payment_gateways_'.$this->id, array(&$this, 'process_admin_options'));

        add_action('woocommerce_api_wc_paygenius_redirect', array(&$this, 'check_response'));

    }

    public function check_response()
    {
        global $woocommerce;
        $order = new WC_Order($_GET['order']);

        $client = $this->getClient();
        $response = $client->info($_GET['ref']);

        //updated by Anthony Galagade
        // $response_data = [
        //     'get'=>$_GET,
        //     'ref'=>$_GET['ref'],
        //     'res'=>$response,
        // ];
        // $logfile = WP_PLUGIN_DIR."/".plugin_basename(dirname(dirname(__FILE__))).'/lib/response.log';
        // $fp = fopen($logfile, 'a');
        // fwrite($fp, json_encode($response_data));
        // fclose($fp);

        if ($response['response']['code'] != 200) {
            return false;
        }

        $responseBody = json_decode($response['body']);
        if(property_exists($responseBody, 'status')){
            if ($responseBody->status == 'SETTLED') {
                $returnUrl = $this->get_return_url($order);
                $order->payment_complete(uniqid());
                $order->reduce_order_stock();
                $order->add_order_note(sprintf(__('Payment Complete', 'woocommerce')));

                $woocommerce->cart->empty_cart();

                wp_redirect($returnUrl);
            } else if ($responseBody->status == 'CANCELLED') {
                wc_add_notice(__('Payment cancelled'),'error');
                wp_redirect(wc_get_cart_url());
            } else if ($responseBody->status == 'AUTHORIZED' || $responseBody->status == 'THREE_D_SECURE') {
                //$order->update_status('on-hold', __('Awaiting payment', 'woocommerce'));
            } else {
                wc_add_notice(__('Payment failed'),'error');
                $order->update_status('failed', 'Payment failed');
                wp_redirect(wc_get_cart_url());
            }
        } else {
            // wc_add_notice(__('Payment failed'),'error');
            // $order->update_status('failed', 'Payment failed');
            // wp_redirect($woocommerce->cart->get_cart_url());
            return false;
        }
        exit;
    }

    public function is_supported()
    {
        return in_array(get_woocommerce_currency(), array('ZAR'));
    }

    public function is_activated()
    {
        if ($this->is_test_mode()) {
            $paymentpage = $this->get_option('testing-paymentpage');
            if (!empty($paymentpage)) {
                return true;
            }
        } else {
            $paymentpage = $this->get_option('paymentpage');
            if (!empty($paymentpage)) {
                return true;
            }
        }

        return false;
    }

    public function getPage()
    {
        if ($this->is_test_mode()) {
            return $this->get_option('testing-paymentpage');
        } else {
            return $this->get_option('paymentpage');
        }
    }

    private function is_test_mode()
    {
        return $this->get_option('testmode') === 'yes';
    }

    public function init_form_fields()
    {
        if (!is_admin()) {
            return;
        }

        $client = $this->getProductionClient();

        $pages = $client->getPages();

        $productionPages = array();
        if (is_array($pages) && isset($pages['body'])) {
            $pages = json_decode($pages['body']);

            if ($pages->success) {
                foreach ($pages->pages as $page) {
                    $productionPages[$page->id] = $page->name;
                }
            }
        }

        /* -- */

        $client = $this->getTestClient();

        $pages = $client->getPages();

        $testingPages = array();
        if (is_array($pages) && isset($pages['body'])) {
            $pages = json_decode($pages['body']);

            if ($pages->success) {
                foreach ($pages->pages as $page) {
                    $testingPages[$page->id] = $page->name;
                }
            }
        }

        if (empty($productionPages)) {
            $productionPages[null] = '- no or invalid api credentials provided -';
        }

        if (empty($testingPages)) {
            $testingPages[null] = '- no or invalid api credentials provided -';
        }

        $this->form_fields = require('includes/form_fields.php');
    }

    private function getClient()
    {
        if ($this->is_test_mode()) {
            return $this->getTestClient();
        } else {
            return $this->getProductionClient();
        }
    }

    private function getProductionClient()
    {
        return new \PayGenius\WebClient($this->get_option('endpoint'), $this->get_option('token'),
            $this->get_option('secret'));
    }

    private function getTestClient()
    {
        return new \PayGenius\WebClient($this->get_option('testing-endpoint'), $this->get_option('testing-token'),
            $this->get_option('testing-secret'));
    }

    private function getRedirectUrl($order_id)
    {
        global $woocommerce;
        $order = new WC_Order($order_id);

        $client = $this->getClient();

        $redirectUrl = add_query_arg('wc-api', 'WC_Paygenius_Redirect', home_url('/'));
        $redirectUrl = add_query_arg('order', $order_id, $redirectUrl).'&ref=${reference}';

        $paygenius_reference = $order_id;

        if ($this->get_option('use_sequence_number') == 'yes')
          $paygenius_reference = $order->get_order_number();

        if ( isset($woocommerce->cart) && $woocommerce->cart ) {
            $woocommerce->cart->calculate_totals();
        }

        $amount_cents = (int) round( $order->get_total() * 100 );

        $response = $client->create($order->get_billing_first_name(), $order->get_billing_last_name(), $amount_cents,
            get_woocommerce_currency(), $order->get_billing_email(), $paygenius_reference, $this->getPage(), $redirectUrl, $redirectUrl,
            $redirectUrl, $redirectUrl);

        if ( empty($response) || ! isset($response['response']['code']) ) {
            error_log('[PayGenius] Empty HTTP response from create()');
            return false;
        }

        if ( (int) $response['response']['code'] !== 200 ) {
            error_log('[PayGenius] HTTP '.$response['response']['code'].' body: '.$response['body']);
            return false;
        }

        $responseBody = json_decode($response['body']);

        if ( empty($responseBody) || empty($responseBody->success) ) {
            error_log('[PayGenius] API failure: '.$response['body']);
            return false;
        }

        //$order->update_status('on-hold', __('Awaiting payment payment', 'woocommerce'));

        return $responseBody->redirectUrl;
    }

    public function process_payment($order_id)
    {
        global $woocommerce;
        $order = new WC_Order($order_id);
        //$order->update_status('on-hold', __( 'Awaiting payment payment', 'woocommerce' ));

        $redirectUrl = add_query_arg('wc-api', 'WC_Paygenius_Redirect', home_url('/'));
        $redirectUrl = add_query_arg('order', $order_id, $redirectUrl).'&ref=${reference}';


        return array(
            'result' => 'success',
            'redirect' => $this->getRedirectUrl($order_id)
        );
    }
}
