<?php

if (!defined('ABSPATH')) {
    exit;
}

return array(
    'enabled' => array(
        'title' => __('Enable/Disable', 'woocommerce-paygenius-redirect'),
        'label' => __('Enable Paygenius', 'woocommerce-paygenius-redirect'),
        'type' => 'checkbox',
        'description' => '',
        'default' => 'no'
    ),
    'title' => array(
        'title' => __('Title', 'woocommerce-paygenius-redirect'),
        'type' => 'text',
        'description' => __('This controls the title which the user sees during checkout.', 'woocommerce-paygenius-redirect'),
        'default' => __('PayGenius Secure payment processing via Credit Card or EFT for South Africa', 'woocommerce-paygenius-redirect'),
        'desc_tip' => true,
    ),
    'description' => array(
        'title' => __('Description', 'woocommerce-paygenius-redirect'),
        'type' => 'textarea',
        'description' => __('This controls the description which the user sees during checkout.', 'woocommerce-paygenius-redirect'),
        'default' => __('Pay by credit/cheque card or instant EFT. No need to register.', 'woocommerce-paygenius-redirect'),
        'desc_tip' => true,
    ),
    'button-text' => array(
        'title' => __('Button Text', 'woocommerce-paygenius-redirect'),
        'type' => 'text',
        'description' => __('The text that will appear on the button clicking through to the PayGenus hosted payment pages', 'woocommerce-paygenius-redirect'),
        'default' => __('Place Order', 'woocommerce-paygenius-redirect'),
        'desc_tip' => true,
    ),
    'production-title' => array(
        'title' => __('Production Options', 'woocommerce-paygenius-redirect'),
        'type' => 'title',
        'description' => empty($productionPages) ? 'Please enter valid API details and ensure you have available payment pages' : '',
    ),
    'paymentpage' => array(
        'title' => __('Payment Page', 'woocommerce-paygenius-redirect'),
        'type' => 'select',
        'description' => __('The payment page to redirect the user to', 'woocommerce-paygenius-redirect'),
        'default' => '',
        'options' => $productionPages,
        'desc_tip' => true,
    ),
    'endpoint' => array(
        'title' => __('Endpoint URL', 'woocommerce-paygenius-redirect'),
        'type' => 'text',
        'description' => __('Production endpoint', 'woocommerce-paygenius-redirect'),
        'default' => 'https://www.paygenius.co.za/pg/api/v2/',
        'desc_tip' => true,
    ),
    'token' => array(
        'title' => __('Token', 'woocommerce-paygenius-redirect'),
        'type' => 'text',
        'description' => __('Get your API keys from your paygenius account.', 'woocommerce-paygenius-redirect'),
        'default' => '',
        'desc_tip' => true,
    ),
    'secret' => array(
        'title' => __('Secret', 'woocommerce-paygenius-redirect'),
        'type' => 'text',
        'description' => __('Get your API keys from your paygenius account.', 'woocommerce-paygenius-redirect'),
        'default' => '',
        'desc_tip' => true,
    ),
    'testing-title' => array(
        'title' => __('Testing Options', 'woocommerce-paygenius-redirect'),
        'type' => 'title',
        'description' => empty($testingPages) ? 'Please enter valid API details and ensure you have available payment pages' : '',
    ),
    'testmode' => array(
        'title' => __('Test mode', 'woocommerce-paygenius-redirect'),
        'label' => __('Enable Test Mode', 'woocommerce-paygenius-redirect'),
        'type' => 'checkbox',
        'description' => __('Place the payment gateway in test mode using test API keys.', 'woocommerce-paygenius-redirect'),
        'default' => 'no',
        'desc_tip' => true,
    ),
    'testing-paymentpage' => array(
        'title' => __('Payment Page', 'woocommerce-paygenius-redirect'),
        'type' => 'select',
        'description' => __('The payment page to redirect the user to', 'woocommerce-paygenius-redirect'),
        'default' => '',
        'options' => $testingPages,
        'desc_tip' => true,
    ),
    'testing-endpoint' => array(
        'title' => __('Endpoint URL', 'woocommerce-paygenius-redirect'),
        'type' => 'text',
        'description' => __('Testing endpoint', 'woocommerce-paygenius-redirect'),
        'default' => 'https://developer.paygenius.co.za/pg/api/v2/',
        'desc_tip' => true,
    ),
    'testing-token' => array(
        'title' => __('Token', 'woocommerce-paygenius-redirect'),
        'type' => 'text',
        'description' => __('Get your API keys from your paygenius account.', 'woocommerce-paygenius-redirect'),
        'default' => '',
        'desc_tip' => true,
    ),
    'testing-secret' => array(
        'title' => __('Secret', 'woocommerce-paygenius-redirect'),
        'type' => 'text',
        'description' => __('Get your API keys from your paygenius account.', 'woocommerce-paygenius-redirect'),
        'default' => '',
        'desc_tip' => true,
    ),
    'use_sequence_number' => array(
        'title' => __('Sequential Order Numbers', 'woocommerce-paygenius-redirect'),
        'label' => __('Enable Sequential Order Numbers', 'woocommerce-paygenius-redirect'),
        'type' => 'checkbox',
        'description' => __('This allows the use of Woocommerce Sequential order numbers', 'woocommerce-paygenius-redirect'),
        'default' => 'no',
        'desc_tip' => true,
    ),
);
