<?php

/*
 * Plugin Name: Paygenius Hosted Payment Gateway
 * Plugin URI: https://developer.paygenius.co.za/
 * Description: Take payments on your store using Paygenius hosted interface.
 * Author: Methys Digital
 * Author URI: http://www.methys.com/digital
 * Version: 1.0.10
 * License:     GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: paygenius-hosted-payment-gateway
 */
if (!defined('ABSPATH')) {
    exit;
}

// Initialize the plugin
add_action('plugins_loaded', 'init_paygenius_redirect');

function init_paygenius_redirect() {
    require_once(__DIR__ . DIRECTORY_SEPARATOR . 'lib' . DIRECTORY_SEPARATOR . 'PayGenius' . DIRECTORY_SEPARATOR . 'WebClient.php');
    require_once(__DIR__ . DIRECTORY_SEPARATOR . 'lib' . DIRECTORY_SEPARATOR . 'WC_Paygenius_Redirect.php');

    add_filter('woocommerce_payment_gateways', 'add_paygenius_redirect');
}

function add_paygenius_redirect($methods) {
    $methods[] = 'WC_Paygenius_Redirect';

    return $methods;
}
